vec3 saturation(color_correction c, vec3 color){
	float grey = luminance(color);
	return grey + c.saturation * (color - grey);
}

vec3 vibrance(color_correction c, vec3 color){
	float cmin = min3(color);
	float cmax = max3(color);

	float saturation = cmax - cmin;
	float grey = luminance(color);

	return mix(vec3(grey), color, 1.0 + c.vibrance * (1.0 - sign(c.vibrance) * saturation));
}

vec3 lift_gamma_gain(color_correction c, vec3 color){
	vec3 lerpV = saturate(pow(color, c.gamma));
	return c.gain * lerpV + c.lift * (1.0 - lerpV);
}

float log_contrast(float x, float eps, float logMidpoint, float contrast){
	float logX = log2(x + eps);
	float adjX = (logX - logMidpoint) * contrast + logMidpoint;

	return max0(exp2(adjX) - eps);	
}

vec3 contrast(color_correction c, vec3 color) {
	const float contrastEpsilon = 1e-5;

	vec3 ret;
	     ret.x = log_contrast(color.x, contrastEpsilon, log2(0.18), c.contrast);
		 ret.y = log_contrast(color.y, contrastEpsilon, log2(0.18), c.contrast);
		 ret.z = log_contrast(color.z, contrastEpsilon, log2(0.18), c.contrast);

	return ret;
}

vec3 post_process(inout vec3 color){
    color_correction c = scolor_correction();

    color = saturation(c, color);
    color = vibrance(c, color);
    color = lift_gamma_gain(c, color);
    color = contrast(c, color);

    return color;
}